<?php
include '../includes/db.php';

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // ডিলিট করার আগে থাম্বনেইলের পাথ ডেটাবেস থেকে নিন
    $sql_select = "SELECT thumbnail_path FROM live_streams WHERE id = ?";
    $stmt_select = $conn->prepare($sql_select);
    $stmt_select->bind_param("i", $id);
    $stmt_select->execute();
    $result = $stmt_select->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $thumbnail_path = $row['thumbnail_path'];

        // সার্ভার থেকে ছবিটি ডিলিট করুন
        if (!empty($thumbnail_path) && file_exists('../' . $thumbnail_path)) {
            unlink('../' . $thumbnail_path);
        }
    }

    // ডেটাবেস থেকে রেকর্ড ডিলিট করুন
    $sql_delete = "DELETE FROM live_streams WHERE id = ?";
    $stmt_delete = $conn->prepare($sql_delete);
    $stmt_delete->bind_param("i", $id);

    if ($stmt_delete->execute()) {
        header("Location: manage_streams.php");
        exit();
    } else {
        echo "ডিলিট করার সময় একটি ত্রুটি হয়েছে: " . $conn->error;
    }
} else {
    echo "অবৈধ অনুরোধ।";
}

$conn->close();
?>